/*! URI.js v1.19.1 http://medialize.github.io/URI.js/ */
/* build contains: URI.js, URITemplate.js, jquery.URI.js */
/*
 URI.js - Mutating URLs

 Version: 1.19.1

 Author: Rodney Rehm
 Web: http://medialize.github.io/URI.js/

 Licensed under
   MIT License http://www.opensource.org/licenses/mit-license

 URI.js - Mutating URLs
 URI Template Support - http://tools.ietf.org/html/rfc6570

 Version: 1.19.1

 Author: Rodney Rehm
 Web: http://medialize.github.io/URI.js/

 Licensed under
   MIT License http://www.opensource.org/licenses/mit-license

 URI.js - Mutating URLs
 jQuery Plugin

 Version: 1.19.1

 Author: Rodney Rehm
 Web: http://medialize.github.io/URI.js/jquery-uri-plugin.html

 Licensed under
   MIT License http://www.opensource.org/licenses/mit-license

*/
(function(g,q){"object"===typeof module&&module.exports?module.exports=q(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains")):"function"===typeof define&&define.amd?define(["./punycode","./IPv6","./SecondLevelDomains"],q):g.URI=q(g.punycode,g.IPv6,g.SecondLevelDomains,g)})(this,function(g,q,l,v){function c(a,b){var d=1<=arguments.length,k=2<=arguments.length;if(!(this instanceof c))return d?k?new c(a,b):new c(a):new c;if(void 0===a){if(d)throw new TypeError("undefined is not a valid argument for URI");
    a="undefined"!==typeof location?location.href+"":""}if(null===a&&d)throw new TypeError("null is not a valid argument for URI");this.href(a);return void 0!==b?this.absoluteTo(b):this}function y(a){return a.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function A(a){return void 0===a?"Undefined":String(Object.prototype.toString.call(a)).slice(8,-1)}function p(a){return"Array"===A(a)}function h(a,b){var d={},c;if("RegExp"===A(b))d=null;else if(p(b)){var m=0;for(c=b.length;m<c;m++)d[b[m]]=!0}else d[b]=
    !0;m=0;for(c=a.length;m<c;m++)if(d&&void 0!==d[a[m]]||!d&&b.test(a[m]))a.splice(m,1),c--,m--;return a}function n(a,b){var d;if(p(b)){var c=0;for(d=b.length;c<d;c++)if(!n(a,b[c]))return!1;return!0}var m=A(b);c=0;for(d=a.length;c<d;c++)if("RegExp"===m){if("string"===typeof a[c]&&a[c].match(b))return!0}else if(a[c]===b)return!0;return!1}function z(a,b){if(!p(a)||!p(b)||a.length!==b.length)return!1;a.sort();b.sort();for(var d=0,c=a.length;d<c;d++)if(a[d]!==b[d])return!1;return!0}function f(a){return a.replace(/^\/+|\/+$/g,
    "")}function r(a){return escape(a)}function t(a){return encodeURIComponent(a).replace(/[!'()*]/g,r).replace(/\*/g,"%2A")}function B(a){return function(b,d){if(void 0===b)return this._parts[a]||"";this._parts[a]=b||null;this.build(!d);return this}}function x(a,b){return function(d,c){if(void 0===d)return this._parts[a]||"";null!==d&&(d+="",d.charAt(0)===b&&(d=d.substring(1)));this._parts[a]=d;this.build(!c);return this}}var u=v&&v.URI;c.version="1.19.1";var e=c.prototype,w=Object.prototype.hasOwnProperty;
    c._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:c.preventInvalidHostname,duplicateQueryParameters:c.duplicateQueryParameters,escapeQuerySpace:c.escapeQuerySpace}};c.preventInvalidHostname=!1;c.duplicateQueryParameters=!1;c.escapeQuerySpace=!0;c.protocol_expression=/^[a-z][a-z0-9.+-]*$/i;c.idn_expression=/[^a-z0-9\._-]/i;c.punycode_expression=/(xn--)/i;c.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
    c.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
    c.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))/ig;c.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?\u00ab\u00bb\u201c\u201d\u201e\u2018\u2019]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g};c.defaultPorts={http:"80",https:"443",ftp:"21",
        gopher:"70",ws:"80",wss:"443"};c.hostProtocols=["http","https"];c.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/;c.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"};c.getDomAttribute=function(a){if(a&&a.nodeName){var b=a.nodeName.toLowerCase();if("input"!==b||"image"===a.type)return c.domAttributes[b]}};c.encode=t;c.decode=decodeURIComponent;c.iso8859=
        function(){c.encode=escape;c.decode=unescape};c.unicode=function(){c.encode=t;c.decode=decodeURIComponent};c.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/ig,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@",
                    "%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}};c.encodeQuery=function(a,b){var d=c.encode(a+"");void 0===b&&(b=c.escapeQuerySpace);return b?d.replace(/%20/g,"+"):d};c.decodeQuery=
        function(a,b){a+="";void 0===b&&(b=c.escapeQuerySpace);try{return c.decode(b?a.replace(/\+/g,"%20"):a)}catch(d){return a}};var C={encode:"encode",decode:"decode"},D,E=function(a,b){return function(d){try{return c[b](d+"").replace(c.characters[a][b].expression,function(d){return c.characters[a][b].map[d]})}catch(k){return d}}};for(D in C)c[D+"PathSegment"]=E("pathname",C[D]),c[D+"UrnPathSegment"]=E("urnpath",C[D]);C=function(a,b,d){return function(k){var m=d?function(a){return c[b](c[d](a))}:c[b];
        k=(k+"").split(a);for(var e=0,f=k.length;e<f;e++)k[e]=m(k[e]);return k.join(a)}};c.decodePath=C("/","decodePathSegment");c.decodeUrnPath=C(":","decodeUrnPathSegment");c.recodePath=C("/","encodePathSegment","decode");c.recodeUrnPath=C(":","encodeUrnPathSegment","decode");c.encodeReserved=E("reserved","encode");c.parse=function(a,b){b||(b={preventInvalidHostname:c.preventInvalidHostname});var d=a.indexOf("#");-1<d&&(b.fragment=a.substring(d+1)||null,a=a.substring(0,d));d=a.indexOf("?");-1<d&&(b.query=
        a.substring(d+1)||null,a=a.substring(0,d));"//"===a.substring(0,2)?(b.protocol=null,a=a.substring(2),a=c.parseAuthority(a,b)):(d=a.indexOf(":"),-1<d&&(b.protocol=a.substring(0,d)||null,b.protocol&&!b.protocol.match(c.protocol_expression)?b.protocol=void 0:"//"===a.substring(d+1,d+3)?(a=a.substring(d+3),a=c.parseAuthority(a,b)):(a=a.substring(d+1),b.urn=!0)));b.path=a;return b};c.parseHost=function(a,b){a||(a="");a=a.replace(/\\/g,"/");var d=a.indexOf("/");-1===d&&(d=a.length);if("["===a.charAt(0)){var k=
        a.indexOf("]");b.hostname=a.substring(1,k)||null;b.port=a.substring(k+2,d)||null;"/"===b.port&&(b.port=null)}else{var m=a.indexOf(":");k=a.indexOf("/");m=a.indexOf(":",m+1);-1!==m&&(-1===k||m<k)?(b.hostname=a.substring(0,d)||null,b.port=null):(k=a.substring(0,d).split(":"),b.hostname=k[0]||null,b.port=k[1]||null)}b.hostname&&"/"!==a.substring(d).charAt(0)&&(d++,a="/"+a);b.preventInvalidHostname&&c.ensureValidHostname(b.hostname,b.protocol);b.port&&c.ensureValidPort(b.port);return a.substring(d)||
        "/"};c.parseAuthority=function(a,b){a=c.parseUserinfo(a,b);return c.parseHost(a,b)};c.parseUserinfo=function(a,b){var d=a.indexOf("/"),k=a.lastIndexOf("@",-1<d?d:a.length-1);-1<k&&(-1===d||k<d)?(d=a.substring(0,k).split(":"),b.username=d[0]?c.decode(d[0]):null,d.shift(),b.password=d[0]?c.decode(d.join(":")):null,a=a.substring(k+1)):(b.username=null,b.password=null);return a};c.parseQuery=function(a,b){if(!a)return{};a=a.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!a)return{};for(var d={},k=a.split("&"),
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m=k.length,e,f,h=0;h<m;h++)if(e=k[h].split("="),f=c.decodeQuery(e.shift(),b),e=e.length?c.decodeQuery(e.join("="),b):null,w.call(d,f)){if("string"===typeof d[f]||null===d[f])d[f]=[d[f]];d[f].push(e)}else d[f]=e;return d};c.build=function(a){var b="";a.protocol&&(b+=a.protocol+":");a.urn||!b&&!a.hostname||(b+="//");b+=c.buildAuthority(a)||"";"string"===typeof a.path&&("/"!==a.path.charAt(0)&&"string"===typeof a.hostname&&(b+="/"),b+=a.path);"string"===typeof a.query&&a.query&&(b+="?"+a.query);"string"===
    typeof a.fragment&&a.fragment&&(b+="#"+a.fragment);return b};c.buildHost=function(a){var b="";if(a.hostname)b=c.ip6_expression.test(a.hostname)?b+("["+a.hostname+"]"):b+a.hostname;else return"";a.port&&(b+=":"+a.port);return b};c.buildAuthority=function(a){return c.buildUserinfo(a)+c.buildHost(a)};c.buildUserinfo=function(a){var b="";a.username&&(b+=c.encode(a.username));a.password&&(b+=":"+c.encode(a.password));b&&(b+="@");return b};c.buildQuery=function(a,b,d){var k="",m,e;for(m in a)if(w.call(a,
        m)&&m)if(p(a[m])){var f={};var h=0;for(e=a[m].length;h<e;h++)void 0!==a[m][h]&&void 0===f[a[m][h]+""]&&(k+="&"+c.buildQueryParameter(m,a[m][h],d),!0!==b&&(f[a[m][h]+""]=!0))}else void 0!==a[m]&&(k+="&"+c.buildQueryParameter(m,a[m],d));return k.substring(1)};c.buildQueryParameter=function(a,b,d){return c.encodeQuery(a,d)+(null!==b?"="+c.encodeQuery(b,d):"")};c.addQuery=function(a,b,d){if("object"===typeof b)for(var k in b)w.call(b,k)&&c.addQuery(a,k,b[k]);else if("string"===typeof b)void 0===a[b]?
        a[b]=d:("string"===typeof a[b]&&(a[b]=[a[b]]),p(d)||(d=[d]),a[b]=(a[b]||[]).concat(d));else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");};c.setQuery=function(a,b,d){if("object"===typeof b)for(var k in b)w.call(b,k)&&c.setQuery(a,k,b[k]);else if("string"===typeof b)a[b]=void 0===d?null:d;else throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");};c.removeQuery=function(a,b,d){var k;if(p(b))for(d=0,k=b.length;d<k;d++)a[b[d]]=
        void 0;else if("RegExp"===A(b))for(k in a)b.test(k)&&(a[k]=void 0);else if("object"===typeof b)for(k in b)w.call(b,k)&&c.removeQuery(a,k,b[k]);else if("string"===typeof b)void 0!==d?"RegExp"===A(d)?!p(a[b])&&d.test(a[b])?a[b]=void 0:a[b]=h(a[b],d):a[b]!==String(d)||p(d)&&1!==d.length?p(a[b])&&(a[b]=h(a[b],d)):a[b]=void 0:a[b]=void 0;else throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");};c.hasQuery=function(a,b,d,k){switch(A(b)){case "String":break;
        case "RegExp":for(var m in a)if(w.call(a,m)&&b.test(m)&&(void 0===d||c.hasQuery(a,m,d)))return!0;return!1;case "Object":for(var e in b)if(w.call(b,e)&&!c.hasQuery(a,e,b[e]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");}switch(A(d)){case "Undefined":return b in a;case "Boolean":return a=!(p(a[b])?!a[b].length:!a[b]),d===a;case "Function":return!!d(a[b],b,a);case "Array":return p(a[b])?(k?n:z)(a[b],d):!1;case "RegExp":return p(a[b])?
        k?n(a[b],d):!1:!(!a[b]||!a[b].match(d));case "Number":d=String(d);case "String":return p(a[b])?k?n(a[b],d):!1:a[b]===d;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");}};c.joinPaths=function(){for(var a=[],b=[],d=0,k=0;k<arguments.length;k++){var m=new c(arguments[k]);a.push(m);m=m.segment();for(var e=0;e<m.length;e++)"string"===typeof m[e]&&b.push(m[e]),m[e]&&d++}if(!b.length||!d)return new c("");b=(new c("")).segment(b);
        ""!==a[0].path()&&"/"!==a[0].path().slice(0,1)||b.path("/"+b.path());return b.normalize()};c.commonPath=function(a,b){var d=Math.min(a.length,b.length),c;for(c=0;c<d;c++)if(a.charAt(c)!==b.charAt(c)){c--;break}if(1>c)return a.charAt(0)===b.charAt(0)&&"/"===a.charAt(0)?"/":"";if("/"!==a.charAt(c)||"/"!==b.charAt(c))c=a.substring(0,c).lastIndexOf("/");return a.substring(0,c+1)};c.withinString=function(a,b,d){d||(d={});var k=d.start||c.findUri.start,m=d.end||c.findUri.end,e=d.trim||c.findUri.trim,f=
        d.parens||c.findUri.parens,h=/[a-z0-9-]=["']?$/i;for(k.lastIndex=0;;){var r=k.exec(a);if(!r)break;var t=r.index;if(d.ignoreHtml){var g=a.slice(Math.max(t-3,0),t);if(g&&h.test(g))continue}var n=t+a.slice(t).search(m);g=a.slice(t,n);for(n=-1;;){var B=f.exec(g);if(!B)break;n=Math.max(n,B.index+B[0].length)}g=-1<n?g.slice(0,n)+g.slice(n).replace(e,""):g.replace(e,"");g.length<=r[0].length||d.ignore&&d.ignore.test(g)||(n=t+g.length,r=b(g,t,n,a),void 0===r?k.lastIndex=n:(r=String(r),a=a.slice(0,t)+r+a.slice(n),
        k.lastIndex=t+r.length))}k.lastIndex=0;return a};c.ensureValidHostname=function(a,b){var d=!!a,k=!1;b&&(k=n(c.hostProtocols,b));if(k&&!d)throw new TypeError("Hostname cannot be empty, if protocol is "+b);if(a&&a.match(c.invalid_hostname_characters)){if(!g)throw new TypeError('Hostname "'+a+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');if(g.toASCII(a).match(c.invalid_hostname_characters))throw new TypeError('Hostname "'+a+'" contains characters other than [A-Z0-9.-:_]');
    }};c.ensureValidPort=function(a){if(a){var b=Number(a);if(!(/^[0-9]+$/.test(b)&&0<b&&65536>b))throw new TypeError('Port "'+a+'" is not a valid port');}};c.noConflict=function(a){if(a)return a={URI:this.noConflict()},v.URITemplate&&"function"===typeof v.URITemplate.noConflict&&(a.URITemplate=v.URITemplate.noConflict()),v.IPv6&&"function"===typeof v.IPv6.noConflict&&(a.IPv6=v.IPv6.noConflict()),v.SecondLevelDomains&&"function"===typeof v.SecondLevelDomains.noConflict&&(a.SecondLevelDomains=v.SecondLevelDomains.noConflict()),
        a;v.URI===this&&(v.URI=u);return this};e.build=function(a){if(!0===a)this._deferred_build=!0;else if(void 0===a||this._deferred_build)this._string=c.build(this._parts),this._deferred_build=!1;return this};e.clone=function(){return new c(this)};e.valueOf=e.toString=function(){return this.build(!1)._string};e.protocol=B("protocol");e.username=B("username");e.password=B("password");e.hostname=B("hostname");e.port=B("port");e.query=x("query","?");e.fragment=x("fragment","#");e.search=function(a,b){var d=
        this.query(a,b);return"string"===typeof d&&d.length?"?"+d:d};e.hash=function(a,b){var d=this.fragment(a,b);return"string"===typeof d&&d.length?"#"+d:d};e.pathname=function(a,b){if(void 0===a||!0===a){var d=this._parts.path||(this._parts.hostname?"/":"");return a?(this._parts.urn?c.decodeUrnPath:c.decodePath)(d):d}this._parts.path=this._parts.urn?a?c.recodeUrnPath(a):"":a?c.recodePath(a):"/";this.build(!b);return this};e.path=e.pathname;e.href=function(a,b){var d;if(void 0===a)return this.toString();
        this._string="";this._parts=c._parts();var k=a instanceof c,e="object"===typeof a&&(a.hostname||a.path||a.pathname);a.nodeName&&(e=c.getDomAttribute(a),a=a[e]||"",e=!1);!k&&e&&void 0!==a.pathname&&(a=a.toString());if("string"===typeof a||a instanceof String)this._parts=c.parse(String(a),this._parts);else if(k||e){k=k?a._parts:a;for(d in k)"query"!==d&&w.call(this._parts,d)&&(this._parts[d]=k[d]);k.query&&this.query(k.query,!1)}else throw new TypeError("invalid input");this.build(!b);return this};
    e.is=function(a){var b=!1,d=!1,k=!1,e=!1,f=!1,h=!1,r=!1,g=!this._parts.urn;this._parts.hostname&&(g=!1,d=c.ip4_expression.test(this._parts.hostname),k=c.ip6_expression.test(this._parts.hostname),b=d||k,f=(e=!b)&&l&&l.has(this._parts.hostname),h=e&&c.idn_expression.test(this._parts.hostname),r=e&&c.punycode_expression.test(this._parts.hostname));switch(a.toLowerCase()){case "relative":return g;case "absolute":return!g;case "domain":case "name":return e;case "sld":return f;case "ip":return b;case "ip4":case "ipv4":case "inet4":return d;
        case "ip6":case "ipv6":case "inet6":return k;case "idn":return h;case "url":return!this._parts.urn;case "urn":return!!this._parts.urn;case "punycode":return r}return null};var F=e.protocol,G=e.port,H=e.hostname;e.protocol=function(a,b){if(a&&(a=a.replace(/:(\/\/)?$/,""),!a.match(c.protocol_expression)))throw new TypeError('Protocol "'+a+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]");return F.call(this,a,b)};e.scheme=e.protocol;e.port=function(a,b){if(this._parts.urn)return void 0===
    a?"":this;void 0!==a&&(0===a&&(a=null),a&&(a+="",":"===a.charAt(0)&&(a=a.substring(1)),c.ensureValidPort(a)));return G.call(this,a,b)};e.hostname=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0!==a){var d={preventInvalidHostname:this._parts.preventInvalidHostname};if("/"!==c.parseHost(a,d))throw new TypeError('Hostname "'+a+'" contains characters other than [A-Z0-9.-]');a=d.hostname;this._parts.preventInvalidHostname&&c.ensureValidHostname(a,this._parts.protocol)}return H.call(this,
        a,b)};e.origin=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){var d=this.protocol();return this.authority()?(d?d+"://":"")+this.authority():""}d=c(a);this.protocol(d.protocol()).authority(d.authority()).build(!b);return this};e.host=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a)return this._parts.hostname?c.buildHost(this._parts):"";if("/"!==c.parseHost(a,this._parts))throw new TypeError('Hostname "'+a+'" contains characters other than [A-Z0-9.-]');
        this.build(!b);return this};e.authority=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a)return this._parts.hostname?c.buildAuthority(this._parts):"";if("/"!==c.parseAuthority(a,this._parts))throw new TypeError('Hostname "'+a+'" contains characters other than [A-Z0-9.-]');this.build(!b);return this};e.userinfo=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){var d=c.buildUserinfo(this._parts);return d?d.substring(0,d.length-1):d}"@"!==a[a.length-1]&&
    (a+="@");c.parseUserinfo(a,this._parts);this.build(!b);return this};e.resource=function(a,b){if(void 0===a)return this.path()+this.search()+this.hash();var d=c.parse(a);this._parts.path=d.path;this._parts.query=d.query;this._parts.fragment=d.fragment;this.build(!b);return this};e.subdomain=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var d=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,
        d)||""}d=this._parts.hostname.length-this.domain().length;d=this._parts.hostname.substring(0,d);d=new RegExp("^"+y(d));a&&"."!==a.charAt(a.length-1)&&(a+=".");if(-1!==a.indexOf(":"))throw new TypeError("Domains cannot contain colons");a&&c.ensureValidHostname(a,this._parts.protocol);this._parts.hostname=this._parts.hostname.replace(d,a);this.build(!b);return this};e.domain=function(a,b){if(this._parts.urn)return void 0===a?"":this;"boolean"===typeof a&&(b=a,a=void 0);if(void 0===a){if(!this._parts.hostname||
        this.is("IP"))return"";var d=this._parts.hostname.match(/\./g);if(d&&2>d.length)return this._parts.hostname;d=this._parts.hostname.length-this.tld(b).length-1;d=this._parts.hostname.lastIndexOf(".",d-1)+1;return this._parts.hostname.substring(d)||""}if(!a)throw new TypeError("cannot set domain empty");if(-1!==a.indexOf(":"))throw new TypeError("Domains cannot contain colons");c.ensureValidHostname(a,this._parts.protocol);!this._parts.hostname||this.is("IP")?this._parts.hostname=a:(d=new RegExp(y(this.domain())+
        "$"),this._parts.hostname=this._parts.hostname.replace(d,a));this.build(!b);return this};e.tld=function(a,b){if(this._parts.urn)return void 0===a?"":this;"boolean"===typeof a&&(b=a,a=void 0);if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var d=this._parts.hostname.lastIndexOf(".");d=this._parts.hostname.substring(d+1);return!0!==b&&l&&l.list[d.toLowerCase()]?l.get(this._parts.hostname)||d:d}if(a)if(a.match(/[^a-zA-Z0-9-]/))if(l&&l.is(a))d=new RegExp(y(this.tld())+"$"),this._parts.hostname=
        this._parts.hostname.replace(d,a);else throw new TypeError('TLD "'+a+'" contains characters other than [A-Z0-9]');else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");d=new RegExp(y(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(d,a)}else throw new TypeError("cannot set TLD empty");this.build(!b);return this};e.directory=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path&&
        !this._parts.hostname)return"";if("/"===this._parts.path)return"/";var d=this._parts.path.length-this.filename().length-1;d=this._parts.path.substring(0,d)||(this._parts.hostname?"/":"");return a?c.decodePath(d):d}d=this._parts.path.length-this.filename().length;d=this._parts.path.substring(0,d);d=new RegExp("^"+y(d));this.is("relative")||(a||(a="/"),"/"!==a.charAt(0)&&(a="/"+a));a&&"/"!==a.charAt(a.length-1)&&(a+="/");a=c.recodePath(a);this._parts.path=this._parts.path.replace(d,a);this.build(!b);
        return this};e.filename=function(a,b){if(this._parts.urn)return void 0===a?"":this;if("string"!==typeof a){if(!this._parts.path||"/"===this._parts.path)return"";var d=this._parts.path.lastIndexOf("/");d=this._parts.path.substring(d+1);return a?c.decodePathSegment(d):d}d=!1;"/"===a.charAt(0)&&(a=a.substring(1));a.match(/\.?\//)&&(d=!0);var k=new RegExp(y(this.filename())+"$");a=c.recodePath(a);this._parts.path=this._parts.path.replace(k,a);d?this.normalizePath(b):this.build(!b);return this};e.suffix=
        function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path||"/"===this._parts.path)return"";var d=this.filename(),k=d.lastIndexOf(".");if(-1===k)return"";d=d.substring(k+1);d=/^[a-z0-9%]+$/i.test(d)?d:"";return a?c.decodePathSegment(d):d}"."===a.charAt(0)&&(a=a.substring(1));if(d=this.suffix())k=a?new RegExp(y(d)+"$"):new RegExp(y("."+d)+"$");else{if(!a)return this;this._parts.path+="."+c.recodePath(a)}k&&(a=c.recodePath(a),this._parts.path=this._parts.path.replace(k,
            a));this.build(!b);return this};e.segment=function(a,b,d){var c=this._parts.urn?":":"/",e=this.path(),h="/"===e.substring(0,1);e=e.split(c);void 0!==a&&"number"!==typeof a&&(d=b,b=a,a=void 0);if(void 0!==a&&"number"!==typeof a)throw Error('Bad segment "'+a+'", must be 0-based integer');h&&e.shift();0>a&&(a=Math.max(e.length+a,0));if(void 0===b)return void 0===a?e:e[a];if(null===a||void 0===e[a])if(p(b)){e=[];a=0;for(var r=b.length;a<r;a++)if(b[a].length||e.length&&e[e.length-1].length)e.length&&!e[e.length-
    1].length&&e.pop(),e.push(f(b[a]))}else{if(b||"string"===typeof b)b=f(b),""===e[e.length-1]?e[e.length-1]=b:e.push(b)}else b?e[a]=f(b):e.splice(a,1);h&&e.unshift("");return this.path(e.join(c),d)};e.segmentCoded=function(a,b,d){var e;"number"!==typeof a&&(d=b,b=a,a=void 0);if(void 0===b){a=this.segment(a,b,d);if(p(a)){var f=0;for(e=a.length;f<e;f++)a[f]=c.decode(a[f])}else a=void 0!==a?c.decode(a):void 0;return a}if(p(b))for(f=0,e=b.length;f<e;f++)b[f]=c.encode(b[f]);else b="string"===typeof b||b instanceof
    String?c.encode(b):b;return this.segment(a,b,d)};var I=e.query;e.query=function(a,b){if(!0===a)return c.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("function"===typeof a){var d=c.parseQuery(this._parts.query,this._parts.escapeQuerySpace),e=a.call(this,d);this._parts.query=c.buildQuery(e||d,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!b);return this}return void 0!==a&&"string"!==typeof a?(this._parts.query=c.buildQuery(a,this._parts.duplicateQueryParameters,
        this._parts.escapeQuerySpace),this.build(!b),this):I.call(this,a,b)};e.setQuery=function(a,b,d){var e=c.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("string"===typeof a||a instanceof String)e[a]=void 0!==b?b:null;else if("object"===typeof a)for(var f in a)w.call(a,f)&&(e[f]=a[f]);else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");this._parts.query=c.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);"string"!==typeof a&&
    (d=b);this.build(!d);return this};e.addQuery=function(a,b,d){var e=c.parseQuery(this._parts.query,this._parts.escapeQuerySpace);c.addQuery(e,a,void 0===b?null:b);this._parts.query=c.buildQuery(e,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);"string"!==typeof a&&(d=b);this.build(!d);return this};e.removeQuery=function(a,b,d){var e=c.parseQuery(this._parts.query,this._parts.escapeQuerySpace);c.removeQuery(e,a,b);this._parts.query=c.buildQuery(e,this._parts.duplicateQueryParameters,
        this._parts.escapeQuerySpace);"string"!==typeof a&&(d=b);this.build(!d);return this};e.hasQuery=function(a,b,d){var e=c.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return c.hasQuery(e,a,b,d)};e.setSearch=e.setQuery;e.addSearch=e.addQuery;e.removeSearch=e.removeQuery;e.hasSearch=e.hasQuery;e.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()};
    e.normalizeProtocol=function(a){"string"===typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!a));return this};e.normalizeHostname=function(a){this._parts.hostname&&(this.is("IDN")&&g?this._parts.hostname=g.toASCII(this._parts.hostname):this.is("IPv6")&&q&&(this._parts.hostname=q.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!a));return this};e.normalizePort=function(a){"string"===typeof this._parts.protocol&&
    this._parts.port===c.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!a));return this};e.normalizePath=function(a){var b=this._parts.path;if(!b)return this;if(this._parts.urn)return this._parts.path=c.recodeUrnPath(this._parts.path),this.build(!a),this;if("/"===this._parts.path)return this;b=c.recodePath(b);var d="";if("/"!==b.charAt(0)){var e=!0;b="/"+b}if("/.."===b.slice(-3)||"/."===b.slice(-2))b+="/";b=b.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/");e&&(d=b.substring(1).match(/^(\.\.\/)+/)||
        "")&&(d=d[0]);for(;;){var f=b.search(/\/\.\.(\/|$)/);if(-1===f)break;else if(0===f){b=b.substring(3);continue}var h=b.substring(0,f).lastIndexOf("/");-1===h&&(h=f);b=b.substring(0,h)+b.substring(f+3)}e&&this.is("relative")&&(b=d+b.substring(1));this._parts.path=b;this.build(!a);return this};e.normalizePathname=e.normalizePath;e.normalizeQuery=function(a){"string"===typeof this._parts.query&&(this._parts.query.length?this.query(c.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=
        null,this.build(!a));return this};e.normalizeFragment=function(a){this._parts.fragment||(this._parts.fragment=null,this.build(!a));return this};e.normalizeSearch=e.normalizeQuery;e.normalizeHash=e.normalizeFragment;e.iso8859=function(){var a=c.encode,b=c.decode;c.encode=escape;c.decode=decodeURIComponent;try{this.normalize()}finally{c.encode=a,c.decode=b}return this};e.unicode=function(){var a=c.encode,b=c.decode;c.encode=t;c.decode=unescape;try{this.normalize()}finally{c.encode=a,c.decode=b}return this};
    e.readable=function(){var a=this.clone();a.username("").password("").normalize();var b="";a._parts.protocol&&(b+=a._parts.protocol+"://");a._parts.hostname&&(a.is("punycode")&&g?(b+=g.toUnicode(a._parts.hostname),a._parts.port&&(b+=":"+a._parts.port)):b+=a.host());a._parts.hostname&&a._parts.path&&"/"!==a._parts.path.charAt(0)&&(b+="/");b+=a.path(!0);if(a._parts.query){for(var d="",e=0,f=a._parts.query.split("&"),h=f.length;e<h;e++){var r=(f[e]||"").split("=");d+="&"+c.decodeQuery(r[0],this._parts.escapeQuerySpace).replace(/&/g,
        "%26");void 0!==r[1]&&(d+="="+c.decodeQuery(r[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}b+="?"+d.substring(1)}return b+=c.decodeQuery(a.hash(),!0)};e.absoluteTo=function(a){var b=this.clone(),d=["protocol","username","password","hostname","port"],e,f;if(this._parts.urn)throw Error("URNs do not have any generally defined hierarchical components");a instanceof c||(a=new c(a));if(b._parts.protocol)return b;b._parts.protocol=a._parts.protocol;if(this._parts.hostname)return b;for(e=0;f=d[e];e++)b._parts[f]=
        a._parts[f];b._parts.path?(".."===b._parts.path.substring(-2)&&(b._parts.path+="/"),"/"!==b.path().charAt(0)&&(d=(d=a.directory())?d:0===a.path().indexOf("/")?"/":"",b._parts.path=(d?d+"/":"")+b._parts.path,b.normalizePath())):(b._parts.path=a._parts.path,b._parts.query||(b._parts.query=a._parts.query));b.build();return b};e.relativeTo=function(a){var b=this.clone().normalize();if(b._parts.urn)throw Error("URNs do not have any generally defined hierarchical components");a=(new c(a)).normalize();var d=
        b._parts;var e=a._parts;var f=b.path();a=a.path();if("/"!==f.charAt(0))throw Error("URI is already relative");if("/"!==a.charAt(0))throw Error("Cannot calculate a URI relative to another relative URI");d.protocol===e.protocol&&(d.protocol=null);if(d.username===e.username&&d.password===e.password&&null===d.protocol&&null===d.username&&null===d.password&&d.hostname===e.hostname&&d.port===e.port)d.hostname=null,d.port=null;else return b.build();if(f===a)return d.path="",b.build();f=c.commonPath(f,a);
        if(!f)return b.build();e=e.path.substring(f.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");d.path=e+d.path.substring(f.length)||"./";return b.build()};e.equals=function(a){var b=this.clone(),d=new c(a);a={};var e;b.normalize();d.normalize();if(b.toString()===d.toString())return!0;var f=b.query();var h=d.query();b.query("");d.query("");if(b.toString()!==d.toString()||f.length!==h.length)return!1;b=c.parseQuery(f,this._parts.escapeQuerySpace);h=c.parseQuery(h,this._parts.escapeQuerySpace);for(e in b)if(w.call(b,
        e)){if(!p(b[e])){if(b[e]!==h[e])return!1}else if(!z(b[e],h[e]))return!1;a[e]=!0}for(e in h)if(w.call(h,e)&&!a[e])return!1;return!0};e.preventInvalidHostname=function(a){this._parts.preventInvalidHostname=!!a;return this};e.duplicateQueryParameters=function(a){this._parts.duplicateQueryParameters=!!a;return this};e.escapeQuerySpace=function(a){this._parts.escapeQuerySpace=!!a;return this};return c});
(function(g,q){"object"===typeof module&&module.exports?module.exports=q(require("./URI")):"function"===typeof define&&define.amd?define(["./URI"],q):g.URITemplate=q(g.URI,g)})(this,function(g,q){function l(c){if(l._cache[c])return l._cache[c];if(!(this instanceof l))return new l(c);this.expression=c;l._cache[c]=this;return this}function v(c){this.data=c;this.cache={}}var c=q&&q.URITemplate,y=Object.prototype.hasOwnProperty,A=l.prototype,p={"":{prefix:"",separator:",",named:!1,empty_name_separator:!1,
        encode:"encode"},"+":{prefix:"",separator:",",named:!1,empty_name_separator:!1,encode:"encodeReserved"},"#":{prefix:"#",separator:",",named:!1,empty_name_separator:!1,encode:"encodeReserved"},".":{prefix:".",separator:".",named:!1,empty_name_separator:!1,encode:"encode"},"/":{prefix:"/",separator:"/",named:!1,empty_name_separator:!1,encode:"encode"},";":{prefix:";",separator:";",named:!0,empty_name_separator:!1,encode:"encode"},"?":{prefix:"?",separator:"&",named:!0,empty_name_separator:!0,encode:"encode"},
    "&":{prefix:"&",separator:"&",named:!0,empty_name_separator:!0,encode:"encode"}};l._cache={};l.EXPRESSION_PATTERN=/\{([^a-zA-Z0-9%_]?)([^\}]+)(\}|$)/g;l.VARIABLE_PATTERN=/^([^*:.](?:\.?[^*:.])*)((\*)|:(\d+))?$/;l.VARIABLE_NAME_PATTERN=/[^a-zA-Z0-9%_.]/;l.LITERAL_PATTERN=/[<>{}"`^| \\]/;l.expand=function(c,g,z){var f=p[c.operator],h=f.named?"Named":"Unnamed";c=c.variables;var t=[],n,x;for(x=0;n=c[x];x++){var u=g.get(n.name);if(0===u.type&&z&&z.strict)throw Error('Missing expansion value for variable "'+
    n.name+'"');if(u.val.length){if(1<u.type&&n.maxlength)throw Error('Invalid expression: Prefix modifier not applicable to variable "'+n.name+'"');t.push(l["expand"+h](u,f,n.explode,n.explode&&f.separator||",",n.maxlength,n.name))}else u.type&&t.push("")}return t.length?f.prefix+t.join(f.separator):""};l.expandNamed=function(c,n,l,f,r,t){var h="",x=n.encode;n=n.empty_name_separator;var u=!c[x].length,e=2===c.type?"":g[x](t),q;var z=0;for(q=c.val.length;z<q;z++){if(r){var p=g[x](c.val[z][1].substring(0,
    r));2===c.type&&(e=g[x](c.val[z][0].substring(0,r)))}else u?(p=g[x](c.val[z][1]),2===c.type?(e=g[x](c.val[z][0]),c[x].push([e,p])):c[x].push([void 0,p])):(p=c[x][z][1],2===c.type&&(e=c[x][z][0]));h&&(h+=f);l?h+=e+(n||p?"=":"")+p:(z||(h+=g[x](t)+(n||p?"=":"")),2===c.type&&(h+=e+","),h+=p)}return h};l.expandUnnamed=function(c,n,l,f,r){var h="",p=n.encode;n=n.empty_name_separator;var z=!c[p].length,q;var e=0;for(q=c.val.length;e<q;e++){if(r)var w=g[p](c.val[e][1].substring(0,r));else z?(w=g[p](c.val[e][1]),
    c[p].push([2===c.type?g[p](c.val[e][0]):void 0,w])):w=c[p][e][1];h&&(h+=f);if(2===c.type){var v=r?g[p](c.val[e][0].substring(0,r)):c[p][e][0];h+=v;h=l?h+(n||w?"=":""):h+","}h+=w}return h};l.noConflict=function(){q.URITemplate===l&&(q.URITemplate=c);return l};A.expand=function(c,n){var h="";this.parts&&this.parts.length||this.parse();c instanceof v||(c=new v(c));for(var f=0,r=this.parts.length;f<r;f++)h+="string"===typeof this.parts[f]?this.parts[f]:l.expand(this.parts[f],c,n);return h};A.parse=function(){var c=
    this.expression,n=l.EXPRESSION_PATTERN,g=l.VARIABLE_PATTERN,f=l.VARIABLE_NAME_PATTERN,r=l.LITERAL_PATTERN,t=[],q=0,x=function(c){if(c.match(r))throw Error('Invalid Literal "'+c+'"');return c};for(n.lastIndex=0;;){var u=n.exec(c);if(null===u){t.push(x(c.substring(q)));break}else t.push(x(c.substring(q,u.index))),q=u.index+u[0].length;if(!p[u[1]])throw Error('Unknown Operator "'+u[1]+'" in "'+u[0]+'"');if(!u[3])throw Error('Unclosed Expression "'+u[0]+'"');var e=u[2].split(",");for(var w=0,v=e.length;w<
v;w++){var y=e[w].match(g);if(null===y)throw Error('Invalid Variable "'+e[w]+'" in "'+u[0]+'"');if(y[1].match(f))throw Error('Invalid Variable Name "'+y[1]+'" in "'+u[0]+'"');e[w]={name:y[1],explode:!!y[3],maxlength:y[4]&&parseInt(y[4],10)}}if(!e.length)throw Error('Expression Missing Variable(s) "'+u[0]+'"');t.push({expression:u[0],operator:u[1],variables:e})}t.length||t.push(x(c));this.parts=t;return this};v.prototype.get=function(c){var g=this.data,h={type:0,val:[],encode:[],encodeReserved:[]};
    if(void 0!==this.cache[c])return this.cache[c];this.cache[c]=h;g="[object Function]"===String(Object.prototype.toString.call(g))?g(c):"[object Function]"===String(Object.prototype.toString.call(g[c]))?g[c](c):g[c];if(void 0!==g&&null!==g)if("[object Array]"===String(Object.prototype.toString.call(g))){var f=0;for(c=g.length;f<c;f++)void 0!==g[f]&&null!==g[f]&&h.val.push([void 0,String(g[f])]);h.val.length&&(h.type=3)}else if("[object Object]"===String(Object.prototype.toString.call(g))){for(f in g)y.call(g,
        f)&&void 0!==g[f]&&null!==g[f]&&h.val.push([f,String(g[f])]);h.val.length&&(h.type=2)}else h.type=1,h.val.push([void 0,String(g)]);return h};g.expand=function(c,n){var h=(new l(c)).expand(n);return new g(h)};return l});
(function(g,q){"object"===typeof module&&module.exports?module.exports=q(require("jquery"),require("./URI")):"function"===typeof define&&define.amd?define(["jquery","./URI"],q):q(g.jQuery,g.URI)})(this,function(g,q){function l(c){return c.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function v(c){var f=c.nodeName.toLowerCase();if("input"!==f||"image"===c.type)return q.domAttributes[f]}function c(c){return{get:function(f){return g(f).uri()[c]()},set:function(f,h){g(f).uri()[c](h);return h}}}function y(c,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          h){if(!v(c)||!h)return!1;var f=h.match(n);if(!f||!f[5]&&":"!==f[2]&&!p[f[2]])return!1;var r=g(c).uri();if(f[5])return r.is(f[5]);if(":"===f[2]){var l=f[1].toLowerCase()+":";return p[l]?p[l](r,f[4]):!1}l=f[1].toLowerCase();return A[l]?p[f[2]](r[l](),f[4],l):!1}var A={},p={"=":function(c,g){return c===g},"^=":function(c,g){return!!(c+"").match(new RegExp("^"+l(g),"i"))},"$=":function(c,g){return!!(c+"").match(new RegExp(l(g)+"$","i"))},"*=":function(c,g,h){"directory"===h&&(c+="/");return!!(c+"").match(new RegExp(l(g),
        "i"))},"equals:":function(c,g){return c.equals(g)},"is:":function(c,g){return c.is(g)}};g.each("origin authority directory domain filename fragment hash host hostname href password path pathname port protocol query resource scheme search subdomain suffix tld username".split(" "),function(f,h){A[h]=!0;g.attrHooks["uri:"+h]=c(h)});var h=function(c,h){return g(c).uri().href(h).toString()};g.each(["src","href","action","uri","cite"],function(c,l){g.attrHooks[l]={set:h}});g.attrHooks.uri.get=function(c){return g(c).uri()};
    g.fn.uri=function(c){var f=this.first(),g=f.get(0),h=v(g);if(!h)throw Error('Element "'+g.nodeName+'" does not have either property: href, src, action, cite');if(void 0!==c){var l=f.data("uri");if(l)return l.href(c);c instanceof q||(c=q(c||""))}else{if(c=f.data("uri"))return c;c=q(f.attr(h)||"")}c._dom_element=g;c._dom_attribute=h;c.normalize();f.data("uri",c);return c};q.prototype.build=function(c){if(this._dom_element)this._string=q.build(this._parts),this._deferred_build=!1,this._dom_element.setAttribute(this._dom_attribute,
        this._string),this._dom_element[this._dom_attribute]=this._string;else if(!0===c)this._deferred_build=!0;else if(void 0===c||this._deferred_build)this._string=q.build(this._parts),this._deferred_build=!1;return this};var n=/^([a-zA-Z]+)\s*([\^\$*]?=|:)\s*(['"]?)(.+)\3|^\s*([a-zA-Z0-9]+)\s*$/;var z=g.expr.createPseudo?g.expr.createPseudo(function(c){return function(f){return y(f,c)}}):function(c,g,h){return y(c,h[3])};g.expr[":"].uri=z;return g});