(function() {

    var prefix = function(key) {
        return 'url:' + key;
    };
    var cache = function () {

        this.storage = window.localStorage ? window.localStorage : {
            data: {},
            removeItem: function (key) {
                delete this.data[key];
            },
            getItem: function (key) {
                console.log('Get from local: ' + key);
                return this.data[key];
            },
            setItem: function (key, cachedData) {
                console.log('Set to local: ' + key);
                this.removeItem(key);
                this.data[key] = cachedData;
            }
        };
    };

    cache.prototype.removeItem = function(key) {
        this.storage.removeItem(prefix(key));
    };
    cache.prototype.getItem = function(key) {
        try {
            return window.JSON.parse(this.storage.getItem(prefix(key)));
        } catch (e) {
            return {};
        }
    };
    cache.prototype.setItem = function(key, cachedData) {
        this.storage.setItem(prefix(key), window.JSON.stringify(cachedData));
    };

    var now = function() {
        return Math.floor(Date.now() / 1000);
    };

    var LocalCache = function(options) {

        var settings = {
            expires : 0,
            ajax : {}
        };
        for (var i in settings) {
            if (options.hasOwnProperty(i)) {
                settings[i] = options[i];
            }
        }

        var _cache = new cache();

        var optionsBeforeSend = settings.ajax.hasOwnProperty('beforeSend') ? settings.ajax.beforeSend : function(){};
        var optionsSuccess = settings.ajax.hasOwnProperty('success') ? settings.ajax.success : function(){};
        var optionsError = settings.ajax.hasOwnProperty('error') ? settings.ajax.error : function(){};

        settings.ajax.beforeSend = function() {

            if (typeof window.LocalCacheUsing != 'undefined' && !window.LocalCacheUsing) {
                return true;
            }

            if (optionsBeforeSend() !== false) {
                var data = _cache.getItem(settings.ajax.url);
                if (data !== null && settings.expires > 0 && data.date + settings.expires >= now()) {
                    if (data.isError) {
                        optionsError(data.response);
                    } else {
                        optionsSuccess(data.response);
                    }
                    return false;
                }
                return true;
            }
            return false;
        };

        settings.ajax.success = function(response) {

            var cachedData = {
                date : now(),
                isError : false,
                response : response
            };
            _cache.setItem(settings.ajax.url, cachedData);
            optionsSuccess(response);
        };

        settings.ajax.error = function(response) {

            var cachedData = {
                date : now(),
                isError : true,
                response : response
            };
            _cache.setItem(settings.ajax.url, cachedData);
            optionsError(response);
        };

        this.settings = settings;
    };

    LocalCache.using = true;
    LocalCache.prototype.run = function() {
        $.ajax(this.settings.ajax);
    };

    window.LocalCache = LocalCache;

})();