var postbackCounter = 0;
var pixelCounter = 0;
$(document).ready(function () {
    var subs = {
        'l': '',
        'to': ''
    };
    var landingTypes = {
        '1': 'l',
        '2': 'to'
    };
    var $link = $('#flow-link');
    var makeLink = function () {
        if (!$link.length) {
            return;
        }
        var query = [];
        for (var i in subs) {
            if (subs[i] != '') {
                query.push(i + '=' + subs[i]);
            }
        }
        var useSSL = $('#use_ssl:checked').val() ? true : false;
        query = query.join('&');
        var delimiter = $link.data('value').indexOf("?") !== -1 ? '&' : '?';
        query = query == '' ? '' : delimiter + query;
        $link.val((useSSL ? "https://" : "http://" ) + $link.data('value').toString().replace(/https?:\/\//, '') + query);
    };
    $(".link-manager-panel").on("change", "input", function () {

        var toggle = $(this).data('toggle');
        $('#' + toggle).slideToggle();

        // fill zero
        switch (toggle) {
            case 'subs-block':
                for (var i = 1; i < 6; i++) {
                    subs['sub' + i] = '';
                    $("#sub" + i).val('');
                }
                break;
            case 'deeplink-block':
                subs['path'] = '';
                $("#path").val('');
                break;
            case 'landing-block':
                subs['l'] = '';
                $('input[name="' + $('.flow-landing[data-type=1]').attr('name') + '"]').filter('[value=""]').prop('checked', true);
                break;
            case 'transit-block':
                subs['to'] = '';
                $('input[name="' + $('.flow-landing[data-type=2]').attr('name') + '"]').filter('[value=""]').prop('checked', true);
                break;
        }
        makeLink();
    });
    var changeCallback = function ($this) {
        return function (e) {
            var val = $this.val();
            if (!val && e.originalEvent.clipboardData) {
                val = e.originalEvent.clipboardData.getData('text');
            }
            if ($this.attr('id') == 'path') {
                val = encodeURIComponent(val).replace(/=+/g, '')
            }
            subs[$this.attr('id')] = val;
            makeLink();
        };
    };
    $('.flow-sub').each(function () {
        var $this = $(this);
        var _changeCallback = changeCallback($this);

        subs[$this.attr('id')] = $this.val();
        $this.keyup(_changeCallback);
        $this.bind("paste", _changeCallback);
    });
    makeLink();
    $('#use_ssl').on('change', function () {
        makeLink();
    });
    $('.flow-landing').on('change', function () {
        var lValue = $('input.flow-landing[data-type=1]:checked').val();
        var toValue = $('input.flow-landing[data-type=2]:checked').val();
        subs['l'] = '';
        subs['to'] = '';

        if (toValue) {
            subs.l = toValue;
            var url = $link.data('value') + (lValue ? '&l=' + lValue : '');
            subs.to = encodeURIComponent(window.base64_encode(url));
        } else if (lValue) {
            subs.l = lValue;
        }
        makeLink();
    });
    $(".panel-body").on('click', ".your-postbacks", function () {
        $(".postback-body").slideToggle();
        $(this).find('i.fa').toggleClass('fa-caret-down').toggleClass('fa-caret-right');
    });
    $(".panel-body").on('click', ".your-creatives", function () {
        $(".creatives-body").slideToggle();
        $(this).find('i.fa').toggleClass('fa-caret-down').toggleClass('fa-caret-right');
    });

    $('#wrapper-postbacks').on('click', '.rm-row', function () {
        if (confirm($(this).data('alert'))) {
            var table = $('#wrapper-postbacks table');
            $(this).closest('tr').remove();
            if (table.find('tr').length <= 1) {
                table.hide();
            }
        }
    });

    $('#wrapper-pixels').on('click', '.rm-pixel-row', function () {
        if (confirm($(this).data('alert'))) {
            var row = $(this).closest('tr');
            row.find('.delete-mark').val('1');
            row.find('[required=required]').each(function() {
                $(this).removeAttr('required');
            });
            row.hide();
        }
    });

    if ($.fn.editable) {
        $.fn.editable.defaults.highlight = false;
        $.fn.editable.defaults.mode = 'popup';
        $.fn.editableform.template = '<form class="editableform">' +
            '<div class="control-group">' +
            '<div class="editable-input"></div> <div class="editable-buttons"></div>' +
            '<div class="editable-error-block"></div>' +
            '</div> ' +
            '</form>';
        $.fn.editableform.buttons =
            '<button type="submit" class="btn btn-info btn-icon editable-submit"><i class="icon-check"></i></button>' +
            '<button type="button" class="btn btn-default btn-icon editable-cancel"><i class="icon-x"></i></button>';


        $('.edit-postback').editable({
            success: function (response, newValue) {
                $(this).parent().find('input').val(newValue);
            }
        });
    }

    $('#new-postback').click(function () {
        postbackCounter++;
        $('#wrapper-postbacks table').show();
        $('#wrapper-postbacks table tr:last').after(
            window.simpleTmpl('postback_row')({postbackCounter: postbackCounter})
        );
        if (window.offer_goals) {
            $.each(window.offer_goals, function (index, value) {
                $('#wrapper-postbacks table tr:last').find('select.postback-goals').append($('<option value="' + index + '">' + value + '</option>'));
            });
        }
        return false;
    });

    $('#new-pixel').click(function () {
        pixelRowCounter++;
        $('#wrapper-pixels table').show();
        $('#wrapper-pixels table tr:last').after(
            window.simpleTmpl('javascript_pixel_row_template')({counter: pixelCounter})
        );
        return false;
    });

    $('select#FlowEdit_offer_id').change(function () {
        var offerId = $(this).val();

        if (offerId) {
            $.get('/offer/' + offerId + '/goals', function (data) {
                if (data) {
                    $("select.postback-goals").empty();
                    $.each(data, function (index, value) {
                        $("select.postback-goals").append($('<option value="' + index + '">' + value + '</option>'));
                    });
                    window.offer_goals = data;
                }
            });
        }
    })
});