$(document).ready(function () {
    $(".js-choose-balance-currency").on("change", function(e) {
        var $this = $(this);
        $(".js-balances").hide();
        $(".js-balance-currency-" + $this.val()).show();
        $(".js-choose-balance-currency option[value=" + $this.val() + "]").prop("selected", true);
    });

    (new UserTimezone()).check();

    $('a.confirm-removing').each(function () {
        var $this = $(this);
        $this.click(function () {
            $($(this).data('target')).find('.submit').data('href', $(this).data('href'));
        });
        $($this.data('target')).find('.submit').click(function (e) {
            e.stopPropagation();
            location.href = $(this).data('href');
        });
    });

    $('.custom-tooltip').tooltip({
        position: 'center top'
    });
    $("[data-toggle=popover]").popover({html: true});

    $('.use-select2').select2();
    $("select.select2-ajax-offers").select2(objGetListOffers);
    $('.use-tooltip').tooltip();
    $('.input-daterange').datepicker({
        format: 'dd-mm-yyyy'

    });

    $('.copy-value').tooltip();
    var clipboard = new Clipboard('.copy-value', {
        text: function(trigger) {
            var text = $(trigger).data('clipboard-text');
            if (!text) {
                var scope = $(trigger);
                while(scope.length) {
                    scope = scope.parent();
                    var input = scope.find('input');
                    if (input.length) {
                        text = input.val();
                        break;
                    }
                }
            }
            return text;
        }
    });
    clipboard.on('success', function(e) {
        e.clearSelection();
        $(e.trigger).next().find('.tooltip-inner').text($(e.trigger).data('copied').replace('{%TEXT%}', e.text));
    });
    //Cookies enabled checked
    var cookiesAttrText = null;
    if ('cookieEnabled' in navigator) {
        cookiesAttrText = navigator.cookieEnabled ? 'enabled' : 'disabled';
    }
    $('.cookie-checker').each( function( index, element ){
        var jElement = $(element);
        if (cookiesAttrText) {
            jElement.html(jElement.data(cookiesAttrText))
        } else {
            jElement.html("Can't check cookies")
        }
    });

});

(function () {

    /**
     * Singleton
     * @constructor
     */
    var Cookie = function () {

        this.cookies = {};
        this.parseCookies = function () {
            var matches = document.cookie.match(/(?:^|; )([^=]+?)=([^;]*)/ig);
            for (var i in matches) {
                var match = matches[i].match(/\b([^=; ]+?)=([^;]*)/i);
                this.cookies[match[1]] = match[2];
            }
        };
        this.parseCookies();
    };

    Cookie.prototype.get = function (name) {
        return this.cookies[name] ? decodeURIComponent(this.cookies[name]) : undefined;
    };

    Cookie.prototype.set = function (name, value, options) {
        options = options || {};

        var expires = options.expires;

        if (typeof expires == "number" && expires) {
            var d = new Date();
            d.setTime(d.getTime() + expires * 1000);
            expires = options.expires = d;
        }
        if (expires && expires.toUTCString) {
            options.expires = expires.toUTCString();
        }

        value = encodeURIComponent(value);

        var updatedCookie = name + "=" + value;

        for (var propName in options) {
            updatedCookie += "; " + propName;
            var propValue = options[propName];
            if (propValue !== true) {
                updatedCookie += "=" + propValue;
            }
        }

        document.cookie = updatedCookie;
        this.parseCookies();
    };

    var UserTimezone = function () {

        this.timezone = window.Cookie.get('timezone');
    };
    UserTimezone.prototype.check = function () {
        if (!this.timezone) {
            var tomorrow = new Date();
            tomorrow.setDate(tomorrow.getDate() + 1);

            var offset = -(new Date()).getTimezoneOffset();
            this.timezone = offset * 60;
            window.Cookie.set('timezone', this.timezone, {expires: tomorrow})
        }
    };

    var base64_encode = function (data) {	// Encodes data with MIME base64
        //
        // +   original by: Tyler Akins (http://rumkin.com)
        // +   improved by: Bayron Guevara

        var b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        var o1, o2, o3, h1, h2, h3, h4, bits, i = 0, enc = '';

        do { // pack three octets into four hexets
            o1 = data.charCodeAt(i++);
            o2 = data.charCodeAt(i++);
            o3 = data.charCodeAt(i++);

            bits = o1 << 16 | o2 << 8 | o3;

            h1 = bits >> 18 & 0x3f;
            h2 = bits >> 12 & 0x3f;
            h3 = bits >> 6 & 0x3f;
            h4 = bits & 0x3f;

            // use hexets to index into b64, and append result to encoded string
            enc += b64.charAt(h1) + b64.charAt(h2) + b64.charAt(h3) + b64.charAt(h4);
        } while (i < data.length);

        switch (data.length % 3) {
            case 1:
                enc = enc.slice(0, -2) + '==';
                break;
            case 2:
                enc = enc.slice(0, -1) + '=';
                break;
        }

        return enc;
    };
    var formatOffer = function (item) {
        if (item.loading) {
            return item.text + '<img style="float: right;" src="/img/loading2.gif"/>';
        }
        return item.title ? '(' + item.int_id + ') ' + item.title : null;
    }

    var formatOfferSelection = function (item) {
        return item.title ? '(' + item.int_id + ') ' + item.title : item.text;
    }
    window.Cookie = new Cookie();
    window.UserTimezone = UserTimezone;
    window.base64_encode = base64_encode;
    window.objGetListOffers = {
        ajax: {
            url: "/offer/get_list_offers",
            dataType: 'json',
            delay: 500,
            data: function (params) {
                var ajaxLoader = '<img id="img_offer_loader" src="/img/loading2.gif"/>';
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, page) {
                return {
                    results: data.items
                };
            },
            cache: true
        },
        minimumInputLength: 1,
        templateResult: formatOffer,
        templateSelection: formatOfferSelection,
        escapeMarkup: function (markup) {
            return markup;
        } // let our custom formatter work
    };

    // simple templating
    window.simpleTmpl = function (str) {
        if (document.getElementById(str)) {
            str = document.getElementById(str).innerHTML;
        }
        return new Function("obj",
            "var p=[],print=function(){p.push.apply(p,arguments);};" +

            // Introduce the data as local variables using with(){}
            "with(obj){p.push('" + str
                .replace(/[\r\t\n]/g, " ")
                .split("<%").join("\t")
                .replace(/((^|%>)[^\t]*)'/g, "$1\r")
                .replace(/\t=(.*?)%>/g, "',$1,'")
                .split("\t").join("');")
                .split("%>").join("p.push('")
                .split("\r").join("\\'") + "');} return p.join('');");
    };

    window.querySerialize = function (obj, prefix) {
        var str = [];
        for (var p in obj) {
            if (obj.hasOwnProperty(p)) {
                var k = prefix ? prefix + "[" + p + "]" : p, v = obj[p];
                str.push(typeof v == "object" ?
                    window.querySerialize(v, k) :
                encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
        return str.join("&");
    };

    Date.prototype.dateFormat = function () {

        var y = this.getFullYear().toString();
        var m = (this.getMonth() + 1).toString();
        var d = this.getDate().toString();

        return (d[1] ? d : '0' + d) + '.' + (m[1] ? m : '0' + m) + '.' + y;
    };

    if (!String.prototype.trim) {
        (function () {
            // Ð’Ñ‹Ñ€ÐµÐ·Ð°ÐµÐ¼ BOM Ð¸ Ð½ÐµÑ€Ð°Ð·Ñ€Ñ‹Ð²Ð½Ñ‹Ð¹ Ð¿Ñ€Ð¾Ð±ÐµÐ»
            String.prototype.trim = function () {
                return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
            };
        })();
    }
    if (!String.prototype.capitalize) {
        String.prototype.capitalize = function () {
            return this.charAt(0).toUpperCase() + this.slice(1);
        }
    }
    Number.prototype.moneyFormat = function(decimals, d, thousands_sep){
        var inputNumber = this,
            decimals = isNaN(decimals = Math.abs(decimals)) ? 2 : decimals,
            dec_point = dec_point == undefined ? "." : dec_point,
            thousands_sep = thousands_sep == undefined ? "," : thousands_sep,
            s = inputNumber < 0 ? "-" : "",
            i = String(parseInt(inputNumber = Math.abs(Number(inputNumber) || 0).toFixed(decimals))),
            j = (j = i.length) > 3 ? j % 3 : 0;
        return s + (j ? i.substr(0, j) + thousands_sep : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands_sep) + (decimals ? dec_point + Math.abs(inputNumber - i).toFixed(decimals).slice(2) : "");
    };

    String.prototype.moneyFormat = function (n, method) {
        method = method ? method : parseFloat;
        return method(this).moneyFormat(n);
    };

    Object.size = function(obj) {
        var size = 0, key;
        for (key in obj) {
            if (obj.hasOwnProperty(key)) size++;
        }
        return size;
    };

    window.moneyHelper = {
        getDecimal: function (value) {
            return Math.abs(value) > 1e-4 ? 4 : 10;
        }
    };
})();